local function isMusicOn()
    return nRes(5) == 1
end

local PLAY_AREA = PlayAreaRect

local BOSS_NAME_SLIDING_TIME = 2029
local BOSS_NAME_SLIDING_TIME2 = 750

function main(self)

    local claw = GetClaw()

    -- Screen coordinates:
	local CENTER_X = PLAY_AREA.Right/2 + 1
	local CENTER_BOSS_NAME = (PLAY_AREA.Bottom+1)*0.3-1
	local END_BOSS_NAME = PLAY_AREA.Right + 138
	local START_Y_BOSS_NAME = -66
    local BOSS_BAR_Y = ((PLAY_AREA.Bottom+1)*0.9+15)

    if self.State == 0 then
        if self.arcanis ~= nil then
            self.State = 1
        end
        return
    end

    if self.State == 1 and claw.I <= 18 then
        mdl_exe.DisablePowerupMusic[0] = 1
        if isMusicOn() then SetMusic("ARCANIS") end
        claw:SetAnimation("CLAW_STAND", 100)
        claw.State = ClawStates.Freeze
        SetRespawnPoint(claw.X,claw.Y)
        self.arcanis.Flags.AlwaysActive = true
        self.arcanis.BossBar = CreateHUDObject{
            X = CENTER_X,
            Y = BOSS_BAR_Y,
            Z = 11000,
            logic = "DoNothing",
            image = "CUSTOM_BOSSBAR"
        }
        CameraToObject(self.arcanis)
        self.timeCounter = GetTime() + 500
        self.aniDelay = GetTime()
        self.State = 2
    end

    -- boss lights up:
    if self.State == 2 and GetTime() > self.timeCounter then
        self.arcanis:SetAnimation"CUSTOM_ARCANIS_FIREUP"
        PlaySound"CUSTOM_ARCANIS_START"
        self.timeCounter = GetTime() + 1100
        self.State = 3
    end

    -- boss starts laughing:
    if self.State == 3 and GetTime() > self.timeCounter  then
        self.timeCounter = GetTime() + 2200
        PlaySound"CUSTOM_ARCANIS_LAUGH"
        self.soundDelay = GetTime() + 2700
        self.arcanis:SetAnimation("CUSTOM_ARCANIS_LAUGH")
        self.aniDelay = GetTime() + 500
        self.State = 4
    end

    -- laughing cycle:
    if self.State >= 4 and self.State <= 7 then
        if GetTime() > self.soundDelay then
            PlaySound"CUSTOM_ARCANIS_LAUGH"
            self.soundDelay = GetTime() + 2700
        end
        if self.arcanis.I == 2 and not self.isFrame002 and GetTime() > self.aniDelay then
            self.aniDelay = GetTime() + 100
            self.isFrame002 = true
        end
        if self.isFrame002 and GetTime() > self.aniDelay then
            self.arcanis:SetAnimation("CUSTOM_ARCANIS_LAUGH")
            self.isFrame002 = false
            self.aniDelay = GetTime() + 200
        end
    end

    -- Claw speaks:
    if self.State == 4 and GetTime() > self.timeCounter then
        CameraToObject(claw)
        ClawSound("CUSTOM_TRIGGER_NOCOMINGBACK")
        self.timeCounter = GetTime() + 2200
        self.State = 5
    end

    -- create the boss name title:
    if self.State == 5 and GetTime() > self.timeCounter then
        Earthquake(3000)
        self.bossName = CreateHUDObject{
            X = CENTER_X,
            Y = START_Y_BOSS_NAME,
            Z = 11000,
            logic = "DoNothing",
            image = "CUSTOM_BOSSNAME"
        }
        PlaySound("GAME_SDPT1")
        self.timeCounter = GetTime()
        self.State = 6
    end

    -- boss name title animation:
    if self.State == 6 then
        self.bossName.Y = START_Y_BOSS_NAME + (CENTER_BOSS_NAME - START_Y_BOSS_NAME) * (GetTime()-self.timeCounter) / BOSS_NAME_SLIDING_TIME
        if GetTime() > self.timeCounter + BOSS_NAME_SLIDING_TIME then
            self.timeCounter = GetTime() + 800
            PlaySound("GAME_SDPT2")
            CameraToClaw()
            self.State = 7
        end
    end

    -- wait for the sound to stop:
    if self.State == 7 and GetTime() > self.timeCounter then
        self.timeCounter = GetTime()
        self.State = 8
    end

    -- boss name title slides out:
    if self.State == 8 then
        self.bossName.X = CENTER_X + (END_BOSS_NAME - CENTER_X) * (GetTime()-self.timeCounter) / BOSS_NAME_SLIDING_TIME2
        if GetTime() > self.timeCounter + BOSS_NAME_SLIDING_TIME2 then
            self.State = 9
        end
    end

    -- last preparations:
    if self.State == 9 then
        claw.State = ClawStates.Stand
        self.arcanis:SetFrame(103)
        self.bossName:Destroy()
        self.State = 10
    end

    -- the fight starts:
    if self.State == 10 then
        self.arcanis.SpeedX, self.arcanis.SpeedY = self.arcanis.speedXPhase1, self.arcanis.speedYPhase1
        self.arcanis:SetAnimation("CUSTOM_ARCANIS_ATTACK1")
        self.arcanis.State = 2
        self:Destroy()
    end

    if claw.Health <= 0 then
        if self.bossName ~= nil then
            self.bossName:Destroy()
        end
        self:Destroy()
    end
end